"""
HB_SlideMode V1.0

Last Modified: Oct/11/2018
Works with CINEMA 4D R16.050 and up.
Copyright: Holger Biebrach, www.c4dstuff.com

Name-US: HB_SlideMode
Description-US: Creates a Setup for Keeping the Shape of the Mesh while editing the topology. Use the HB_Convert Script to convert back to Polygons

Usage:
Select a Polygonobject. After you run the script you can use any modelling Tool.
The shape of the mesh will keep the same. Use the HB_Convert Script to get out of this mode!!!

Video Tutorials:
https://youtu.be/Ki6I9sRdeUU?t=49m24s
https://youtu.be/Xo1qMmVSQ-Q?t=7s
https://youtu.be/ZDkXn5PjsjU

https://youtu.be/UlY-X5O137M?t=327


ChangeLog:


Oct/11/2018 V1.0
- Release Version
- Fixed issue where Polygons where projected wrong


"""

import c4d
from c4d import gui, plugins, utils
from c4d.modules import snap





def tool():
    return plugins.FindPlugin(doc.GetAction(), c4d.PLUGINTYPE_TOOL)




def main():

    drawBD = doc.GetActiveBaseDraw()
    objects=doc.GetSelection()


    if len(objects) !=1 : #ERROR

        gui.MessageDialog("Select one Objects!")
        return

    selobj=objects[0]
    drawBD[c4d.BASEDRAW_DATA_DEFORMEDEDIT]=True


    
    selobjname = selobj.GetName()
    selobjpos = selobj.GetMg()
    #retoponame = selobjname + "_retopo"


    SlideObj=selobj.GetClone()




                                                         # NO Symmetry

    SlideObj.InsertAfter(selobj)
    doc.AddUndo(c4d.UNDOTYPE_NEW, SlideObj)


     #### NORMAL MOVE
    NMsettings = c4d.BaseContainer()                 # Settings
    NMsettings[c4d.MDATA_NORMALMOVE_VALUE] = 0.0001

    utils.SendModelingCommand(command = c4d.ID_MODELING_NORMALMOVE_TOOL,
                                    list = [selobj],
                                    mode = c4d.MODELINGCOMMANDMODE_ALL,
                                    bc = NMsettings,
                                    doc = doc)


    doc.AddUndo(c4d.UNDOTYPE_CHANGE, SlideObj)
    SlideObj.SetMg(selobjpos)

    #SHRINKWRAP
    shrinkwrapdeformer=c4d.BaseObject(1019774)
    shrinkwrapdeformer[c4d.SHRINKWRAP_TARGETOBJECT]=SlideObj
    shrinkwrapdeformer[c4d.ID_BASEOBJECT_VISIBILITY_EDITOR]=1

    shrinkwrapdeformer.InsertUnder(selobj)
    doc.AddUndo(c4d.UNDOTYPE_NEW, shrinkwrapdeformer)
    shrinkwrapdeformer.Message(c4d.MSG_MENUPREPARE)


    # SLIDE MODE

    doc.AddUndo(c4d.UNDOTYPE_CHANGE_SMALL, shrinkwrapdeformer)
    shrinkwrapdeformer.SetName("HB_SlideDeformer")
    doc.AddUndo(c4d.UNDOTYPE_CHANGE_SMALL, SlideObj)
    SlideObj[c4d.ID_BASEOBJECT_VISIBILITY_EDITOR]=1
    SlideObj.SetName("HB_SlideProxy")
    doc.AddUndo(c4d.UNDOTYPE_BITS, SlideObj)
    SlideObj.DelBit(c4d.BIT_ACTIVE)


    doc.EndUndo()




if __name__=='__main__':
    main()
    c4d.EventAdd()